package com.swvoitures.reservation;

/*
* Cette classe constitue l'interface du service d'accs au 
* systme de rservation de la centrale de rservation 
* SW-Voitures.
*
* @version  1.0
*/
public interface IReservationService {

	/*
	* Recherche de disponibilits pour la rservation d'un
	* vhicule.
	*
	* @param		passengers le nombre de passagers
	* @param		from la localit de dpart
	* @param		to la localit d'arrive
	* @param		roundTrip aller retour/aller simple
	* @param		departureDay jour de dpart
	* @param		departureMonth mois de dpart 
	* @param		departureYear anne de dpart
	* @param		arrivalDay jour d'arrive
	* @param		arrivalMonth mois d'arrive 
	* @param		arrivalYear anne d'arrive
	* @param		remoteId identifiant de rservation du partenaire
	*				de rservation
	*
 	* @return		int le n de rservation affect  la recherche
 	*				de disponibilits du client
	*/
	int search(int passengers, String from, String to, boolean roundTrip, 
		int departureDay, int departureMonth, int departureYear, int arrivalDay, 
		int arrivalMonth, int arrivalYear, int remoteId) throws ReservationException;

	/*
	* Confirmation de la rservation dont l'identifiant est
	* pass en paramtre.
	*
	* @param		reservationId le n de la rservation 
	*				confirmer
	* @param		availabilityId le n de disponibilit 
	*				confirmer
	*
	* @return		<code>true</code> si la confirmation s'est
	*				bien passe; <code>false</code> sinon
	*/
	boolean book(int reservationId, int availabilityId)
		throws ReservationException;

	/*
	* Annulation de la rservation dont l'identifiant est
	* pass en paramtre.
	*
	* @param		reservationId le n de la rservation 
	*				annuler
	*
	* @return		<code>true</code> si l'annulation s'est
	*				bien passe; <code>false</code> sinon
	*/
	boolean cancel(int reservationId)
		throws ReservationException;

	/*
	* Renvoie les disponibilits de la centrale de rservation 
	* automobile pour la rservation locale dont l'identifiant
	* est pass en paramtre.
	*
	* @param		reservationId l'identifiant de la
	*				rservation locale
	*
 	* @return		CarAvailability[] les disponibilits de la
 	*				centrale de rservation automobile pour la 
 	*				rservation locale dont l'identifiant est 
 	*				pass en paramtre.
	*/
	CarAvailability[] getCarAvailabilities(int reservationId);
}